(function($) {
	window.addEasyRotatorLightbox = function(opts, fancyboxOpts)
	{
		var optsDefault = {
			// filter: '#blaWrapper',
			showFullCategory: true,		// bool; specifies if just one photo or the entire category should be shown in the lightbox
			text: 'title', 				// none, title, desc
			cursor: 'pointer',
			showHoverOverlay: false, 	// bool
			hoverOverlaySrc: 'fancybox/easyrotator_overlay.png',
			pauseAutoplay: true			// specifies if autoplay should be paused when the lightbox is launched
		};
		opts = $.extend(optsDefault, opts);
		if (/\.cur$/.test(opts.cursor))
			opts.cursor = 'url(\'' + opts.cursor + '\'), pointer';

		var fancyboxOptsDefault = {
			padding: 10, 				// numeric
			transitionIn: 'elastic',
			transitionOut: 'elastic'
			//,titlePosition: 'outside' 	// inside, outside, hover
		};
		fancyboxOpts = $.extend(fancyboxOptsDefault, fancyboxOpts);

		// Setup all of the data for all rotators
		var data = [];
		var ul = $('div.dwuserEasyRotator>div[data-ertype=content]>ul', opts.filter);
		ul.each(function(i){
			var dataImgs = [];
			$(this).children('li').each(function(j){
				// Extract the info for this slide
				var li = $(this);
				var img = li.find('img.main');
				var src = img.attr('data-fullImage') || img.attr('data-srcLightbox') || img.attr('src');
				var title = li.children('span.title').html();
				var desc = li.children('span.desc').html();
	
				// Store the image's info in the tracker; add data so we can reference this later
				var obj = {href:src};
				if (opts.text == 'title' && title && title != '')
					obj.title = title;
				else if (opts.text == 'desc' && desc && desc != '')
					obj.title = desc;
				dataImgs[j] = obj;
				img.attr('data-erLightboxData', i+','+j).css('cursor', opts.cursor);
			});
			// Store the category's info in the tracker
			data[i] = dataImgs;
		});
		
		// Setup all of the listeners for the images
		$('div.dwuserEasyRotator div.erimgMain img.main, div.dwuserEasyRotator div.erimgMainOneUp img.main', opts.filter).live('mouseenter mouseleave click', function(e){
			var img = $(e.target);
			if (/mouseenter|mouseleave/.test(e.type) && opts.showHoverOverlay)
			{
				if (e.type != 'mouseleave' || e.relatedTarget.id != 'erlightboxOverlay')
					$('#erlightboxOverlay').remove();
				if (e.type == 'mouseenter')
				{
					$('<img id="erlightboxOverlay" src="' + opts.hoverOverlaySrc + '" />').load(function(){
						var $this = $(this);
						var mainImgPosition = img.offset();
						$this.css({
							left: mainImgPosition.left + (img.width()-$this.width())/2,
							top: mainImgPosition.top + (img.height()-$this.height())/2
						});
					}).css({
						cursor: opts.cursor, 
						zIndex:10000000,
						position: 'absolute'
					}).click(function(){
						$(this).remove();
						img.trigger('click');
					}).appendTo('body');
				}			
			}
			else if (e.type == 'click')
			{
				// Get the associated data
				var info = img.attr('data-erLightboxData');
				if (!info)
					return;
				var dataID = info.split(',');
				var dataCat = data[dataID[0]],
					dataImg = dataCat[dataID[1]];
				if (opts.showFullCategory)
				{
					// Show fancybox gallery
					$.fancybox(     dataCat, $.extend({}, fancyboxOpts, {index:dataID[1]})     );
				}
				else
				{
					// Show single fancybox image
					$.fancybox( $.extend({}, dataImg, fancyboxOpts) );
				}
				// pause autoplay
				if (opts.pauseAutoplay)
					er_$144(img.get()).parents('div.dwuserEasyRotator').trigger('er_playPause', {v:false});
			}
		});
	};
})(jQuery);